# -*- coding: utf-8 -*-
'''Interface between LS-OPT and User-defined meta-model in Python.
'''
import random

def build(coordinates, values):
    '''Builds the user-defined meta-model.
    @param coordinates: list (list of input parameters)
    @param values: list (list of target values)
    @return int, 1 for signalling LS-OPT if meta-model built.
    '''
    # Here you can call your own meta-model.
    print "Building Meta-Model..."
    return 1

def funcval(coordinates):
    '''Returns the response value for the given input parameters.
    @param coordinates: list (list of input coordinates)
    @return float (value of response)
    '''
    # Here you can call the routine for getting the response value
    # from the meta-model.

    # Just returning random response values.
    return random.uniform(0, 1)

def funcgrad(coordinates):
    '''Returns the derivative for the given coordinates.
    @param coordinates: list (list of input parameters)
    @return float (derivative of the learned function)
    '''
    # Just returning constant derivative.
    return 1.0

