#!/bin/bash

if [ "$(uname)" != "Linux" ]
then
    echo "This script requires a Linux system"
fi

cd $(dirname "$0")
VERSION=$(svnversion)
if echo $VERSION | egrep -q ':|M'
then
    echo "Mixed copy detected."
    echo "Please commit and update entire tree before making distribution."
    exit 1
fi

DIRNAME=lsopt_user_metamodel_$VERSION

# Remove old files
rm -rf lsopt_user_metamodel_*[0-9] lsopt_user_metamodel*.tar.gz lsopt_user_metamodel*.zip

# Create & populate working directory
mkdir $DIRNAME

cp avgdistance.c avgdistance.def avgdistance.vcproj Makefile platform.sh \
  testmodel.c testmodel.vcproj UserMetaModel.h usermetamodel.sln \
  README $DIRNAME

# Generate .tar.gz
export GZIP=-9
tar cvzf ${DIRNAME}.tar.gz $DIRNAME

# Make cosmetic win32-specific changes
cd $DIRNAME
unix2dos *.c *.h *.sh Makefile README
mv README readme.txt
cd ..

# Generate .zip-file
zip -r ${DIRNAME}.zip $DIRNAME

# Clean up
rm -rf ${DIRNAME}

echo ""
echo ""
echo "All done. Generated files:"
du --apparent-size --human-readable ${DIRNAME}.zip ${DIRNAME}.tar.gz
